# getDirectoryToWatchFailedLookupLocationFromTypeRoot

When watched typeRoot handler is invoked, this method determines the directory for which the failedLookupLocation would need to be invalidated.
Since this is invoked only when watching default typeRoot and is used to handle flaky directory watchers, this is used as a fail safe where if failed lookup starts with returned directory we will invalidate that resolution.

## Testing for UncDos root: //vda1cs4850/c$

## RootDirForResolution: //vda1cs4850/c$

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1                                                                    |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1                                                                    |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1                                                                    |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1                                                                    |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1                                                                    |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                            |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                            |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                            |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2                                                            |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                    |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                    |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3                                                    |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                            |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4                                            |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                    |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/users

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/users/username

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1                                                     |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2                                             |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                     |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3                                     |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                             |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4                             |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                     |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/user

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/user/username

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username                                                                           |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username                                                                           |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username                                                                           |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username                                                                           |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username                                                                           |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username                                                                           |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username                                                                           |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot                                                              |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1                                                      |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2                                              |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                      |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3                                      |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                              |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4                              |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                      |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/usr

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/usr/username

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username                                                                            |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username                                                                            |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username                                                                            |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username                                                                            |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username                                                                            |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username                                                                            |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username                                                                            |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot                                                               |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1                                                       |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2                                               |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                       |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3                                       |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                               |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                       |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/home

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/home/username

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username                                                                           |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username                                                                           |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username                                                                           |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username                                                                           |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username                                                                           |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username                                                                           |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username                                                                           |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot                                                              |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1                                                      |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2                                              |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                      |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3                                      |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                              |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4                              |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                      |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/workspaces

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules            |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot                                                                 |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1                                                         |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2                                                 |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                         |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3                                         |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                 |

## RootDirForResolution: //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Directory                                                                                               | getDirectoryToWatchFailedLookupLocationFromTypeRoot                                                     |
| ------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------- |
| //vda1cs4850/c$/folderAtRoot/node_modules/@types                                                        | //vda1cs4850/c$/folderAtRoot/node_modules                                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/node_modules/@types                                                | //vda1cs4850/c$/folderAtRoot/folder1/node_modules                                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules/@types                                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/node_modules                                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules/@types                                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/node_modules                                       |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types                        | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                               |
| //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types                | //vda1cs4850/c$/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules                       |
| //vda1cs4850/c$/users/username/folderAtRoot/node_modules/@types                                         | //vda1cs4850/c$/users/username/folderAtRoot/node_modules                                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules/@types                                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/node_modules                                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules/@types                         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/node_modules                                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                 | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/node_modules                        |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types         | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                |
| //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types | //vda1cs4850/c$/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules        |
| //vda1cs4850/c$/user/node_modules/@types                                                                | //vda1cs4850/c$/user/node_modules                                                                       |
| //vda1cs4850/c$/user/username/node_modules/@types                                                       | //vda1cs4850/c$/user/username/node_modules                                                              |
| //vda1cs4850/c$/user/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/user/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/usr/node_modules/@types                                                                 | //vda1cs4850/c$/usr/node_modules                                                                        |
| //vda1cs4850/c$/usr/username/node_modules/@types                                                        | //vda1cs4850/c$/usr/username/node_modules                                                               |
| //vda1cs4850/c$/usr/username/folderAtRoot/node_modules/@types                                           | //vda1cs4850/c$/usr/username/folderAtRoot/node_modules                                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules/@types                                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/node_modules                                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules/@types                           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/node_modules                                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/node_modules                          |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types           | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                  |
| //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types   | //vda1cs4850/c$/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules          |
| //vda1cs4850/c$/home/node_modules/@types                                                                | //vda1cs4850/c$/home/node_modules                                                                       |
| //vda1cs4850/c$/home/username/node_modules/@types                                                       | //vda1cs4850/c$/home/username/node_modules                                                              |
| //vda1cs4850/c$/home/username/folderAtRoot/node_modules/@types                                          | //vda1cs4850/c$/home/username/folderAtRoot/node_modules                                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules/@types                                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/node_modules                                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules/@types                          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/node_modules                                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules/@types                  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/node_modules                         |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types          | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                 |
| //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types  | //vda1cs4850/c$/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules         |
| //vda1cs4850/c$/workspaces/node_modules/@types                                                          | //vda1cs4850/c$/workspaces/node_modules                                                                 |
| //vda1cs4850/c$/workspaces/folderAtRoot/node_modules/@types                                             | //vda1cs4850/c$/workspaces/folderAtRoot/node_modules                                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules/@types                                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/node_modules                                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules/@types                             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/node_modules                                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules/@types                     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/node_modules                            |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules/@types             | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/node_modules                    |
| //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/node_modules/@types     | //vda1cs4850/c$/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         |

